# Role and Permission System - Complete Guide

## Overview
Ab aapka system **fully dynamic** hai - har role ko explicitly permissions assign karni padengi. Koi bhi automatic permission grant nahi hoga.

## Key Changes Made

### 1. Removed Automatic Permission Grants
- **Pehle**: `organizer_manager` role ko automatically sab organizer permissions milte the
- **Ab**: Har role ko explicitly permissions assign karni padengi
- **Result**: Complete control over who can access what

### 2. Permission Checks Added
- ✅ All organizer pages now check permissions
- ✅ All organizer API endpoints check permissions
- ✅ Proper error messages when access denied

### 3. Dynamic Permission System
- Roles create kar sakte hain
- Permissions assign kar sakte hain roles ko
- Users ko roles assign kar sakte hain
- System automatically checks permissions

## How It Works

### Step 1: Create Roles
1. Go to: `http://localhost/events_belive/admin/pages/roles.php`
2. Create a new role (e.g., "Event Creator")
3. Assign permissions to that role (e.g., `organizer.events.create`)

### Step 2: Assign Roles to Users
1. Go to: `http://localhost/events_belive/admin/pages/users.php`
2. Click "Manage Roles" next to any user
3. Select a role and click "Assign Role"
4. Role is saved in `user_roles` table

### Step 3: Permission Check Flow
When a user tries to access a page/API:
1. System checks: Does user have the required permission?
2. Permission check looks at:
   - User's assigned roles
   - Permissions assigned to those roles
   - Returns true/false
3. If false: Shows "Access Denied" message

## Organizer Permissions

### Available Permissions:
- `organizer.events.view` - View events list
- `organizer.events.create` - Create new events
- `organizer.events.edit` - Edit own events
- `organizer.events.delete` - Delete own events
- `organizer.events.publish` - Publish events
- `organizer.attendees.view` - View attendees
- `organizer.attendees.manage` - Manage attendees
- `organizer.sales.view` - View sales reports
- `organizer.sales.export` - Export sales data
- `organizer.promotions.view` - View promotions
- `organizer.promotions.create` - Create promotions
- `organizer.promotions.edit` - Edit promotions
- `organizer.promotions.delete` - Delete promotions
- `organizer.refunds.view` - View refunds
- `organizer.refunds.process` - Process refunds

## Example: Restrict Event Creation

### Scenario:
Aap chahte hain ki kisi organizer ko event create karne ki permission na ho.

### Steps:
1. **Check current role**: 
   - Go to users page
   - See what role is assigned (e.g., `organizer_manager`)

2. **Edit the role**:
   - Go to Roles & Permissions page
   - Find `organizer_manager` role
   - Remove `organizer.events.create` permission
   - Save

3. **Test**:
   - Logout and login as that organizer
   - Try to access "Create Event" page
   - Should see: "You do not have permission to create events"

## Database Structure

### Tables:
- `roles` - All available roles
- `permissions` - All available permissions
- `role_permissions` - Which permissions are assigned to which roles
- `user_roles` - Which roles are assigned to which users

### Check Data:
```sql
-- See all user role assignments
SELECT ur.*, c.email, r.name as role_name 
FROM user_roles ur
LEFT JOIN customers c ON ur.user_id = c.id
LEFT JOIN roles r ON ur.role_id = r.id;

-- See role permissions
SELECT r.name as role_name, p.name as permission_name, p.slug
FROM role_permissions rp
INNER JOIN roles r ON rp.role_id = r.id
INNER JOIN permissions p ON rp.permission_id = p.id
ORDER BY r.name, p.name;
```

## Testing

### Test Permission System:
1. **Assign role without create permission**:
   - Create a role "Event Viewer"
   - Assign only `organizer.events.view` permission
   - Assign this role to an organizer user

2. **Test access**:
   - Login as that organizer
   - Should be able to view events ✅
   - Should NOT be able to create events ❌
   - Should see "Access Denied" message

## Important Notes

1. **Super Admin & Admin**: Still have all permissions (bypass checks)
2. **Manager Roles**: No longer get automatic permissions - must be explicitly assigned
3. **Permission Checks**: Added to all organizer pages and APIs
4. **Error Messages**: Clear messages when access denied

## Migration Status

Run this to check if migration is complete:
```
http://localhost/events_belive/check_migration_status.php
```

If tables don't exist, run:
```
http://localhost/events_belive/run_roles_migration.php?key=migrate_roles_2024
```

## Support

Agar koi issue ho:
1. Check migration status
2. Verify user has role assigned
3. Verify role has permission assigned
4. Check browser console for errors
5. Check server error logs



