# Organizer Login Credentials

## Organizer Login

Organizers can log in to access their event management dashboard.

**Login URL:** `http://localhost/events_belive/organizer/login.php`

## Test Organizer Accounts

### Account 1: Global Events Inc
- **Email:** `organizer1@example.com`
- **Password:** `organizer123`
- **Company:** Global Events Inc
- **Status:** Verified

### Account 2: Tech Events Co
- **Email:** `organizer2@example.com`
- **Password:** `organizer123` (needs to be set)
- **Company:** Tech Events Co
- **Status:** Verified

## How Organizers Login

1. Go to: `http://localhost/events_belive/organizer/login.php`
2. Enter organizer email and password
3. Click "Login"
4. You'll be redirected to the organizer dashboard

## Alternative Login Methods

Organizers can also:
- Use the regular login page (`/login.html`) with social login (Google, Facebook, LinkedIn)
- After logging in, if they have an organizer account linked, they'll be redirected to the organizer dashboard

## Organizer Panel Features

- **Dashboard:** View statistics and recent events
- **My Events:** Manage all your events
- **Create Event:** Create new events with event wizard
- **Promotions:** Manage promo codes and campaigns
- **Sales & Finance:** Track revenue and sales
- **Attendees:** Manage attendee lists and check-ins
- **Settings:** Update organizer profile and settings

## Setting Up New Organizers

To create a new organizer account:

1. User must first register/login as a regular user
2. Admin needs to create an organizer record linked to that user
3. Or user can request organizer access through the platform

## Password Reset

To reset an organizer password, update it in the database:
```sql
UPDATE customers 
SET password_hash = PASSWORD('new_password') 
WHERE email = 'organizer_email@example.com';
```

