# beLIVE EventsHUB - Login Credentials & URLs

## Admin Panel

**Login URL:** `http://localhost/events_belive/admin/login.php`

**Credentials:**
- **Email:** `admin@belive.com`
- **Password:** `admin123`

**Dashboard:** `http://localhost/events_belive/admin/dashboard.php`

### Admin Modules:
- 📊 Dashboard
- 👥 User Management
- 🏢 Organizers Management
- 🏛️ Venues Management
- 📅 Event Oversight
- 💳 Wallet & BNPL Control
- ⭐ Loyalty & Memberships
- 📈 Analytics & Reports
- 📝 CMS & Content
- 🔔 Notifications
- 💰 Financial Settlement
- ⚙️ Settings

---

## Organizer Panel

**Login URL:** `http://localhost/events_belive/organizer/login.php`

**Test Credentials:**

### Account 1: Global Events Inc
- **Email:** `organizer1@example.com`
- **Password:** `organizer123`
- **Company:** Global Events Inc
- **Status:** Verified

### Account 2: Tech Events Co
- **Email:** `organizer2@example.com`
- **Password:** `organizer123`
- **Company:** Tech Events Co
- **Status:** Verified

**Dashboard:** `http://localhost/events_belive/organizer/dashboard.php`

### Organizer Modules:
- 📊 Dashboard
- 📅 My Events
- ➕ Create Event
- 🎯 Promotions & Marketing
- 💰 Sales & Finance
- 👥 Attendees Management
- 💸 Refund Management
- ⚙️ Settings

---

## Venue Panel

**Login URL:** `http://localhost/events_belive/venue/login.php`

**Test Credentials:**

### Account 1: Grand Convention Center
- **Email:** `venue1@example.com`
- **Password:** `venue123`
- **Venue:** Grand Convention Center
- **Location:** Las Vegas, NV, USA
- **Capacity:** 5000
- **Status:** Verified

### Account 2: Metro Exhibition Hall
- **Email:** `venue2@example.com`
- **Password:** `venue123`
- **Venue:** Metro Exhibition Hall
- **Location:** Chicago, IL, USA
- **Capacity:** 3000
- **Status:** Verified

**Dashboard:** `http://localhost/events_belive/venue/dashboard.php`

### Venue Modules:
- 📊 Dashboard
- 📅 Events at Venue
- 🏛️ Venue Profile
- 📈 Revenue Analytics
- 🔐 Access Control & Operations
- ⚙️ Settings

---

## Customer Portal (Frontend)

**Homepage:** `http://localhost/events_belive/index.html`

**Login:** `http://localhost/events_belive/login.html`

Customers can login using:
- Google OAuth
- Facebook OAuth
- LinkedIn OAuth

Or use test accounts:
- **Email:** `john.doe@example.com` (and other test accounts from dummy data)
- **Password:** (Set via password reset or use social login)

---

## Quick Access Links

### Admin
- Login: `http://localhost/events_belive/admin/login.php`
- Dashboard: `http://localhost/events_belive/admin/dashboard.php`

### Organizer
- Login: `http://localhost/events_belive/organizer/login.php`
- Dashboard: `http://localhost/events_belive/organizer/dashboard.php`

### Venue
- Login: `http://localhost/events_belive/venue/login.php`
- Dashboard: `http://localhost/events_belive/venue/dashboard.php`

### Frontend
- Homepage: `http://localhost/events_belive/index.html`
- Events: `http://localhost/events_belive/events.html`
- About Us: `http://localhost/events_belive/aboutus.html`

---

## Security Notes

⚠️ **Important:** These are default/test credentials. In production:
1. Change all default passwords
2. Use strong, unique passwords
3. Enable 2FA where possible
4. Regularly update passwords
5. Use secure password hashing (already implemented with bcrypt)

---

## Database

- **Host:** localhost
- **Database:** db_events
- **Username:** root
- **Password:** mtv

---

## Features Summary

### Admin Panel Features:
✅ Complete platform governance
✅ User & vendor management
✅ Event approval workflows
✅ Financial settlement & reconciliation
✅ Wallet & BNPL control
✅ Loyalty program management
✅ Analytics & reporting
✅ CMS & content management
✅ Notification system

### Organizer Panel Features:
✅ Event lifecycle management
✅ Event creation wizard
✅ Promotions & marketing tools
✅ Sales & revenue tracking
✅ Attendee management
✅ Refund management
✅ QR-based check-in

### Venue Panel Features:
✅ Venue profile management
✅ Event & occupancy insights
✅ Revenue analytics
✅ Performance tracking
✅ Access control & staff management
✅ Utilization rate monitoring

