# Customers Table - Role & Permission Mapping

## Overview

Ab **customers table** directly role aur permission system se map ho gaya hai. Login system same hai, bas role/permission handle ho raha hai.

## How It Works

### 1. Login System (Unchanged)
- Sabhi users (admin, organizer, venue) **customers table** se login hote hain
- Login process me koi change nahi
- Session me `user_id` store hota hai (customers table ka id)

### 2. User Type Detection (Automatic)
System automatically detect karta hai ki user ka type kya hai:

```php
// Automatically detects from:
// 1. admins table check → 'admin'
// 2. organizers table check → 'organizer'  
// 3. venues table check → 'venue'
// 4. Default → 'customer'

$userType = getCurrentUserType($userId);
```

### 3. Role & Permission Assignment

**Existing Users (Migration se):**
- **Admins** → `super_admin` ya `admin` role assign
- **Organizers** → `organizer_manager` role assign (full permissions)
- **Venues** → `venue_manager` role assign (full permissions)

**New Users:**
- Admin panel se roles assign kar sakte hain
- Custom roles create kar sakte hain
- Permissions assign kar sakte hain

## Usage Examples

### Check Permission (Customers Table se)
```php
require_once __DIR__ . '/includes/permissions.php';

// Works with customers table - automatically detects user type
if (hasPermission('events.view')) {
    // User has permission
}

// For specific customer
if (hasPermission('events.create', $customerId)) {
    // Customer has permission
}
```

### Get User Info with Roles
```php
require_once __DIR__ . '/includes/user_permissions.php';

$user = getUserWithRoles($customerId);
// Returns:
// - Customer info from customers table
// - user_type (admin/organizer/venue/customer)
// - roles array
// - permissions array
// - admin_info/organizer_info/venue_info (if applicable)
```

### Assign Role to Customer
```php
require_once __DIR__ . '/includes/user_permissions.php';

// Assign role to customer
$result = assignRoleToCustomer($customerId, $roleId);
// Automatically detects user_type from admins/organizers/venues table
```

## Database Structure

### Customers Table (Main Login Table)
```sql
SELECT * FROM customers WHERE id = ?
-- All users login from this table
```

### User Roles Mapping
```sql
SELECT * FROM user_roles 
WHERE user_id = ? -- customers.id
AND user_type = ? -- 'admin', 'organizer', 'venue', 'customer'
```

### How User Type is Determined
1. Check `admins` table → if exists → `user_type = 'admin'`
2. Check `organizers` table → if exists → `user_type = 'organizer'`
3. Check `venues` table → if exists → `user_type = 'venue'`
4. Default → `user_type = 'customer'`

## Migration Impact

### Existing Users
- **No breaking changes** - sab kuch same kaam karega
- Existing admins/organizers/venues automatically roles assign ho jayenge
- Login system same rahega

### New Features
- Custom roles create kar sakte hain
- Permissions assign kar sakte hain
- User-specific permissions control

## API Usage

### Get Customer with Roles
```php
GET /api/admin/userrolesapi.php?action=user_roles&user_id=123
// Returns roles for customer (auto-detects user_type)
```

### Assign Role
```php
POST /api/admin/userrolesapi.php?action=assign
{
    "user_id": 123,  // customers.id
    "role_id": 5,
    "user_type": "organizer"  // Optional - auto-detected
}
```

## Important Notes

1. **Login Unchanged**: Customers table se hi login hoga
2. **Auto Detection**: User type automatically detect hota hai
3. **Backward Compatible**: Existing code kaam karega
4. **Flexible**: Custom roles aur permissions assign kar sakte hain

## Example Flow

1. User login karta hai → `customers` table se
2. Session me `user_id` store hota hai
3. System check karta hai:
   - `admins` table me hai? → Admin user
   - `organizers` table me hai? → Organizer user
   - `venues` table me hai? → Venue user
4. User type ke according roles fetch hote hain
5. Permissions check hote hain based on roles

**Sab kuch automatic hai - koi manual mapping ki zarurat nahi!**



