-- Create user_activity table to store social media activity and preferences
CREATE TABLE IF NOT EXISTS `user_activity` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `customer_id` INT(11) NOT NULL,
  `activity_type` VARCHAR(50) NOT NULL COMMENT 'interests, skills, pages, groups, etc.',
  `activity_data` JSON DEFAULT NULL COMMENT 'Structured data from social platforms',
  `keywords` TEXT DEFAULT NULL COMMENT 'Extracted keywords for matching',
  `source` ENUM('google', 'facebook', 'linkedin') NOT NULL,
  `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
  `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_customer_id` (`customer_id`),
  KEY `idx_activity_type` (`activity_type`),
  KEY `idx_source` (`source`),
  CONSTRAINT `fk_user_activity_customer` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Create user_preferences table for storing analyzed preferences
CREATE TABLE IF NOT EXISTS `user_preferences` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `customer_id` INT(11) NOT NULL,
  `preference_type` VARCHAR(50) NOT NULL COMMENT 'event_type, location, industry, etc.',
  `preference_value` VARCHAR(255) NOT NULL,
  `weight` DECIMAL(5,2) DEFAULT 1.00 COMMENT 'Relevance weight',
  `source` VARCHAR(50) DEFAULT NULL COMMENT 'How this preference was derived',
  `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
  `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_preference` (`customer_id`, `preference_type`, `preference_value`),
  KEY `idx_customer_id` (`customer_id`),
  KEY `idx_preference_type` (`preference_type`),
  CONSTRAINT `fk_user_preferences_customer` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add activity_data column to customers table if it doesn't exist
ALTER TABLE `customers` 
ADD COLUMN IF NOT EXISTS `activity_data` JSON DEFAULT NULL COMMENT 'Raw activity data from social platforms',
ADD COLUMN IF NOT EXISTS `interests` TEXT DEFAULT NULL COMMENT 'Comma-separated interests',
ADD COLUMN IF NOT EXISTS `industry` VARCHAR(100) DEFAULT NULL,
ADD COLUMN IF NOT EXISTS `job_title` VARCHAR(200) DEFAULT NULL,
ADD COLUMN IF NOT EXISTS `company` VARCHAR(200) DEFAULT NULL;
