-- Create roles table for admin panel
CREATE TABLE IF NOT EXISTS `roles` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(50) NOT NULL,
  `description` TEXT DEFAULT NULL,
  `permissions` TEXT DEFAULT NULL COMMENT 'JSON array of permissions',
  `is_active` TINYINT(1) DEFAULT 1,
  `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
  `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Create admin_users table for admin panel access
CREATE TABLE IF NOT EXISTS `admin_users` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `username` VARCHAR(100) NOT NULL,
  `email` VARCHAR(255) NOT NULL,
  `password_hash` VARCHAR(255) NOT NULL,
  `full_name` VARCHAR(200) DEFAULT NULL,
  `role_id` INT(11) DEFAULT NULL,
  `customer_id` INT(11) DEFAULT NULL COMMENT 'Link to customers table if created from customer',
  `is_active` TINYINT(1) DEFAULT 1,
  `last_login` DATETIME DEFAULT NULL,
  `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
  `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_username` (`username`),
  UNIQUE KEY `unique_email` (`email`),
  KEY `idx_role` (`role_id`),
  KEY `idx_customer` (`customer_id`),
  FOREIGN KEY (`role_id`) REFERENCES `roles`(`id`) ON DELETE SET NULL,
  FOREIGN KEY (`customer_id`) REFERENCES `customers`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert default roles
INSERT INTO `roles` (`name`, `description`, `permissions`) VALUES
('Super Admin', 'Full system access', '["*"]'),
('Admin', 'Manage events and customers', '["events.*", "customers.*", "users.view"]'),
('Moderator', 'Moderate events and customers', '["events.edit", "customers.view", "customers.edit"]'),
('Viewer', 'View only access', '["events.view", "customers.view", "users.view"]')
ON DUPLICATE KEY UPDATE `name` = `name`;

-- Insert default admin user (password: admin123 - CHANGE THIS!)
-- Password hash for 'admin123'
INSERT INTO `admin_users` (`username`, `email`, `password_hash`, `full_name`, `role_id`) VALUES
('admin', 'admin@belive.com', '$2y$10$JHwCGoQxPux7t/6tyIpGO.zriL3rjVgpb7zDQp.PcZkCBwyKqbOaK', 'System Administrator', 1)
ON DUPLICATE KEY UPDATE `username` = `username`;
