-- Create past_events table to store historical events from last year
CREATE TABLE IF NOT EXISTS `past_events` (
  `id` VARCHAR(255) NOT NULL,
  `name` VARCHAR(500) NOT NULL,
  `start_date` DATE DEFAULT NULL,
  `end_date` DATE DEFAULT NULL,
  `attendees_range` VARCHAR(100) DEFAULT NULL,
  `venue` VARCHAR(255) DEFAULT NULL,
  `city` VARCHAR(100) DEFAULT NULL,
  `country` VARCHAR(100) DEFAULT NULL,
  `ticket_available` TINYINT(1) DEFAULT 0,
  `pricing` VARCHAR(255) DEFAULT NULL,
  `description` TEXT DEFAULT NULL,
  `attendee_profiles` TEXT DEFAULT NULL,
  `sponsors` TEXT DEFAULT NULL,
  `event_type` VARCHAR(50) DEFAULT 'other',
  `website_url` VARCHAR(500) DEFAULT NULL,
  `raw_candidate_json` JSON DEFAULT NULL,
  `findall_id` VARCHAR(255) DEFAULT NULL,
  `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
  `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_start_date` (`start_date`),
  KEY `idx_event_type` (`event_type`),
  KEY `idx_country` (`country`),
  KEY `idx_findall_id` (`findall_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
