<?php
/**
 * Configuration file for beLIVE Events
 */

// Database configuration
// define('DB_HOST', '20.193.252.200');
// define('DB_NAME', 'db_belive_events');
// define('DB_USER', 'sms-belive');
// define('DB_PASS', 'skhcihy@63426');

define('DB_HOST', 'localhost');
define('DB_NAME', 'db_belive_events');
define('DB_USER', 'root');
define('DB_PASS', 'root');

// Session configuration
define('SESSION_LIFETIME', 86400); // 24 hours

// Base URL - Auto-detect from current request
if (!defined('BASE_URL')) {
    // Check if we're in a web request
    if (isset($_SERVER['HTTP_HOST'])) {
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || 
                     (!empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https')) 
                     ? 'https' : 'http';
        $host = $_SERVER['HTTP_HOST'];
        
        // Determine base path - prioritize domain-based detection for production
        $basePath = '';
        
        // For production domain, always use root path
        if (strpos($host, 'belive-events.videostech.cloud') !== false) {
            $basePath = ''; // Production - root domain
        }
        // For alternative production domain
        elseif (strpos($host, 'recognizer.multitvsolution.com') !== false || strpos($host, 'multitvsolution.com') !== false) {
            $basePath = '/events'; // Alternative production path
        }
        // For other domains, detect from script location
        else {
            // If we have SCRIPT_NAME, use it to detect the base path
            if (isset($_SERVER['SCRIPT_NAME'])) {
                $scriptName = $_SERVER['SCRIPT_NAME'];
                
                // If script is in admin folder (e.g., /admin/login.php or /belive_events/admin/login.php)
                if (preg_match('#(/[^/]+)?/admin/#', $scriptName, $matches)) {
                    // Extract the base path before /admin
                    $basePath = $matches[1] ?? '';
                }
                // If script is in api folder (e.g., /api/events.php or /belive_events/api/events.php)
                elseif (preg_match('#(/[^/]+)?/api/#', $scriptName, $matches)) {
                    // Extract the base path before /api
                    $basePath = $matches[1] ?? '';
                }
                // If script is in root (e.g., /index.html)
                else {
                    $scriptDir = dirname($scriptName);
                    // If script is directly in root, basePath is empty
                    // Otherwise, use the directory
                    if ($scriptDir !== '/' && $scriptDir !== '.') {
                        $basePath = $scriptDir;
                    }
                }
                
                // Normalize: remove trailing slashes
                $basePath = rtrim($basePath, '/');
            }
            
            // Fallback for local development
            if ($basePath === '') {
                $basePath = '/belive_events';
            }
        }
        
        define('BASE_URL', $protocol . '://' . $host . $basePath);
    } else {
        // Fallback for CLI or when HTTP_HOST is not set
        define('BASE_URL', 'http://localhost/belive_events');
    }
}

// OAuth Configuration
// Google OAuth
define('GOOGLE_CLIENT_ID', getenv('GOOGLE_CLIENT_ID') ?: '848327141592-lnkqf85orv7tp6lb1bm2ggck4m874794.apps.googleusercontent.com');
define('GOOGLE_CLIENT_SECRET', getenv('GOOGLE_CLIENT_SECRET') ?: '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');
define('GOOGLE_REDIRECT_URI', getenv('GOOGLE_REDIRECT_URI') ?: BASE_URL . '/api/auth/google-callback.php');

// Facebook OAuth
define('FACEBOOK_APP_ID', getenv('FACEBOOK_APP_ID') ?: '1843045946575277');
define('FACEBOOK_APP_SECRET', getenv('FACEBOOK_APP_SECRET') ?: '92ad39c88ab0190833b70fefb59aef9f');
define('FACEBOOK_REDIRECT_URI', getenv('FACEBOOK_REDIRECT_URI') ?: BASE_URL . '/api/auth/facebook-callback.php');

// LinkedIn OAuth
define('LINKEDIN_CLIENT_ID', getenv('LINKEDIN_CLIENT_ID') ?: '86027avvd0ox4e');
define('LINKEDIN_CLIENT_SECRET', getenv('LINKEDIN_CLIENT_SECRET') ?: 'WPL_AP1.qUfgCcXnV2VihPWm.tWILmA==');
define('LINKEDIN_REDIRECT_URI', getenv('LINKEDIN_REDIRECT_URI') ?: BASE_URL . '/api/auth/linkedin-callback.php');

// Stripe Configuration
define('STRIPE_SECRET_KEY_TEST', getenv('STRIPE_SECRET_KEY_TEST') ?: 'sk_test_51RsI9JEDUfhbpxu4hubNs3HiiEF7QeT6c9PREzLPVFYp2dlVNh8V0fIpyEBgR49vJvsz2SBt2HoptrbNIZyT5gnk00Z2ItbmJQ');
define('STRIPE_PUBLISHABLE_KEY_TEST', getenv('STRIPE_PUBLISHABLE_KEY_TEST') ?: 'pk_test_51RsI9JEDUfhbpxu4hubNs3HiiEF7QeT6c9PREzLPVFYp2dlVNh8V0fIpyEBgR49vJvsz2SBt2HoptrbNIZyT5gnk00Z2ItbmJQ');
define('STRIPE_WEBHOOK_SECRET', getenv('STRIPE_WEBHOOK_SECRET') ?: ''); // Add webhook secret when setting up webhooks

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
