<?php
/**
 * Single Event API Endpoint
 * Returns a single event by ID from the database in JSON format
 */

// Error reporting (disable display, enable logging)
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type');

// Database credentials
// Database credentials
// $dbHost = '20.193.252.200';
// $dbName = 'db_belive_events';
// $dbUser = 'sms-belive';
// $dbPass = 'skhcihy@63426';

$dbHost = 'localhost';
$dbName = 'db_belive_events';
$dbUser = 'root';
$dbPass = 'root';
try {
    $pdo = new PDO(
        "mysql:host={$dbHost};dbname={$dbName};charset=utf8mb4",
        $dbUser,
        $dbPass,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Database connection failed',
        'message' => $e->getMessage()
    ]);
    exit;
}

// Get event ID from query parameters
$eventId = isset($_GET['id']) ? trim($_GET['id']) : null;

if (!$eventId) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => 'Event ID is required'
    ]);
    exit;
}

// Build SQL query
$sql = "SELECT 
    id, name, start_date, end_date, attendees_range, venue, city, country,
    ticket_available, pricing, description, attendee_profiles, sponsors,
    event_type, website_url, created_at, updated_at
FROM events
WHERE id = :id
LIMIT 1";

try {
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':id' => $eventId]);
    $event = $stmt->fetch();
    
    if (!$event) {
        http_response_code(404);
        echo json_encode([
            'success' => false,
            'error' => 'Event not found'
        ]);
        exit;
    }
    
    // Format event for frontend
    $formattedEvent = [
        'id' => $event['id'],
        'name' => $event['name'],
        'start_date' => $event['start_date'],
        'end_date' => $event['end_date'],
        'attendees_range' => $event['attendees_range'],
        'venue' => $event['venue'],
        'city' => $event['city'],
        'country' => $event['country'],
        'ticket_available' => (bool)$event['ticket_available'],
        'pricing' => $event['pricing'],
        'description' => $event['description'],
        'attendee_profiles' => $event['attendee_profiles'],
        'sponsors' => $event['sponsors'],
        'event_type' => $event['event_type'],
        'website_url' => $event['website_url'],
    ];
    
    echo json_encode([
        'success' => true,
        'event' => $formattedEvent
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    error_log('Event API Error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'error' => 'Database query failed',
        'message' => 'Unable to fetch event. Please try again later.'
    ]);
} catch (Exception $e) {
    http_response_code(500);
    error_log('Event API Error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'error' => 'Unexpected error',
        'message' => 'An error occurred. Please try again later.'
    ]);
}
