<?php
/**
 * LinkedIn OAuth Login - Initiate OAuth flow
 */

require_once __DIR__ . '/../../config.php';

// Check if LinkedIn OAuth is configured
if (empty(LINKEDIN_CLIENT_ID) || empty(LINKEDIN_CLIENT_SECRET)) {
    header('Location: ../../login.html?error=' . urlencode('LinkedIn OAuth is not configured. Please set LINKEDIN_CLIENT_ID and LINKEDIN_CLIENT_SECRET in environment variables.'));
    exit;
}

// Generate state token for CSRF protection
$state = bin2hex(random_bytes(16));
$_SESSION['oauth_state'] = $state;
$_SESSION['oauth_provider'] = 'linkedin';

// Build LinkedIn OAuth URL
$params = [
    'response_type' => 'code',
    'client_id' => LINKEDIN_CLIENT_ID,
    'redirect_uri' => LINKEDIN_REDIRECT_URI,
    'state' => $state,
    'scope' => 'openid profile email'
];

$authUrl = 'https://www.linkedin.com/oauth/v2/authorization?' . http_build_query($params);

// Redirect to LinkedIn
header('Location: ' . $authUrl);
exit;
