<?php
/**
 * Facebook OAuth Callback - Handle OAuth response
 */

require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/user_activity.php';

// Check for errors
if (isset($_GET['error'])) {
    header('Location: ../../login.html?error=' . urlencode('Authentication failed: ' . $_GET['error']));
    exit;
}

// Verify state token
if (!isset($_GET['state']) || !isset($_SESSION['oauth_state']) || $_GET['state'] !== $_SESSION['oauth_state']) {
    header('Location: ../../login.html?error=' . urlencode('Invalid state token. Please try again.'));
    exit;
}

// Check for authorization code
if (!isset($_GET['code'])) {
    header('Location: ../../login.html?error=' . urlencode('Authorization code not received.'));
    exit;
}

$code = $_GET['code'];

try {
    // Exchange authorization code for access token
    $tokenUrl = 'https://graph.facebook.com/v18.0/oauth/access_token';
    $tokenData = [
        'client_id' => FACEBOOK_APP_ID,
        'client_secret' => FACEBOOK_APP_SECRET,
        'redirect_uri' => FACEBOOK_REDIRECT_URI,
        'code' => $code
    ];
    
    $ch = curl_init($tokenUrl . '?' . http_build_query($tokenData));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200) {
        throw new Exception('Failed to exchange authorization code for token');
    }
    
    $tokenResponse = json_decode($response, true);
    
    if (!isset($tokenResponse['access_token'])) {
        throw new Exception('Access token not received');
    }
    
    $accessToken = $tokenResponse['access_token'];
    
    // Get user info from Facebook (with extended fields)
    $userInfoUrl = 'https://graph.facebook.com/v18.0/me?fields=id,name,email,first_name,last_name,picture,location,hometown&access_token=' . urlencode($accessToken);
    
    $ch = curl_init($userInfoUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $userResponse = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200) {
        throw new Exception('Failed to get user information from Facebook');
    }
    
    $userData = json_decode($userResponse, true);
    
    // Format user data for our system
    $formattedUserData = [
        'id' => $userData['id'],
        'email' => $userData['email'] ?? null,
        'name' => $userData['name'] ?? '',
        'first_name' => $userData['first_name'] ?? '',
        'last_name' => $userData['last_name'] ?? '',
        'picture' => $userData['picture']['data']['url'] ?? null,
        'access_token' => $accessToken
    ];
    
    // Create or update user
    $userId = createOrUpdateUser('facebook', $formattedUserData);
    
    // Fetch and store user activity (async-like, don't block on errors)
    try {
        fetchFacebookActivity($accessToken, $userId);
    } catch (Exception $e) {
        error_log('Error fetching Facebook activity: ' . $e->getMessage());
        // Continue with login even if activity fetch fails
    }
    
    // Get full user data
    $pdo = getDB();
    $stmt = $pdo->prepare("SELECT * FROM customers WHERE id = :id");
    $stmt->execute([':id' => $userId]);
    $fullUserData = $stmt->fetch();
    
    // Login user
    loginUser($userId, $fullUserData);
    
    // Clear OAuth state
    unset($_SESSION['oauth_state']);
    unset($_SESSION['oauth_provider']);
    
    // Redirect to home
    header('Location: ../../index.html');
    exit;
    
} catch (Exception $e) {
    error_log('Facebook OAuth Error: ' . $e->getMessage());
    header('Location: ../../login.html?error=' . urlencode('Authentication failed. Please try again.'));
    exit;
}
