<?php
/**
 * Check authentication status
 */

header('Content-Type: application/json');
require_once __DIR__ . '/../../includes/auth.php';

$user = getCurrentUser();

if ($user) {
    // Remove sensitive data
    unset($user['access_token']);
    unset($user['refresh_token']);
    
    echo json_encode([
        'success' => true,
        'authenticated' => true,
        'user' => $user
    ]);
} else {
    echo json_encode([
        'success' => true,
        'authenticated' => false,
        'user' => null
    ]);
}
