<?php
$pageTitle = 'Roles Management';
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/db.php';
requirePermission('users.view');

$pdo = getDB();

// Get all roles
$stmt = $pdo->query("SELECT r.*, COUNT(a.id) as user_count FROM roles r LEFT JOIN admin_users a ON r.id = a.role_id GROUP BY r.id ORDER BY r.name");
$roles = $stmt->fetchAll();
?>

<div class="page-header">
    <h1 class="page-title">Roles Management</h1>
    <p class="page-subtitle">Manage user roles and permissions</p>
</div>

<?php if (hasPermission('users.create')): ?>
<div class="card">
    <a href="role-add.php" class="btn btn-primary">+ Add New Role</a>
</div>
<?php endif; ?>

<!-- Roles Table -->
<div class="card">
    <div class="card-header">
        <h2 class="card-title">Roles (<?php echo count($roles); ?>)</h2>
    </div>
    
    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Role Name</th>
                    <th>Description</th>
                    <th>Permissions</th>
                    <th>Users</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($roles)): ?>
                    <tr>
                        <td colspan="7" style="text-align: center; color: var(--text-medium); padding: 2rem;">No roles found</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($roles as $role): ?>
                        <tr>
                            <td><?php echo $role['id']; ?></td>
                            <td><strong><?php echo htmlspecialchars($role['name']); ?></strong></td>
                            <td><?php echo htmlspecialchars($role['description'] ?? 'N/A'); ?></td>
                            <td>
                                <?php 
                                $permissions = json_decode($role['permissions'] ?? '[]', true);
                                if (in_array('*', $permissions)) {
                                    echo '<span class="badge badge-success">All Permissions</span>';
                                } else {
                                    echo '<small>' . count($permissions) . ' permission(s)</small>';
                                }
                                ?>
                            </td>
                            <td><span class="badge badge-info"><?php echo $role['user_count']; ?></span></td>
                            <td>
                                <?php if ($role['is_active']): ?>
                                    <span class="badge badge-success">Active</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">Inactive</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div style="display: flex; gap: 0.5rem;">
                                    <?php if (hasPermission('users.edit')): ?>
                                        <a href="role-edit.php?id=<?php echo $role['id']; ?>" class="btn btn-secondary btn-sm">Edit</a>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
