<?php
/**
 * Reset Admin Password Script
 * Run this once to set/reset the admin password
 */

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/includes/db.php';

// Security: Only allow this to run if accessed directly with a secret key
$secretKey = 'reset_admin_2025';
$providedKey = $_GET['key'] ?? '';

if ($providedKey !== $secretKey) {
    die('Access denied. Provide ?key=reset_admin_2025');
}

try {
    $pdo = getDB();
    
    // Generate password hash for 'admin123'
    $password = 'admin123';
    $passwordHash = password_hash($password, PASSWORD_DEFAULT);
    
    // Check if admin user exists
    $stmt = $pdo->prepare("SELECT id FROM admin_users WHERE username = 'admin'");
    $stmt->execute();
    $existing = $stmt->fetch();
    
    if ($existing) {
        // Update existing admin user
        $stmt = $pdo->prepare("UPDATE admin_users SET password_hash = :hash WHERE username = 'admin'");
        $stmt->execute([':hash' => $passwordHash]);
        echo "✅ Admin password updated successfully!<br>";
    } else {
        // Create admin user if it doesn't exist
        // First check if Super Admin role exists
        $stmt = $pdo->query("SELECT id FROM roles WHERE name = 'Super Admin' LIMIT 1");
        $role = $stmt->fetch();
        $roleId = $role ? $role['id'] : 1;
        
        $stmt = $pdo->prepare("
            INSERT INTO admin_users (username, email, password_hash, full_name, role_id, is_active) 
            VALUES ('admin', 'admin@belive.com', :hash, 'System Administrator', :role_id, 1)
        ");
        $stmt->execute([':hash' => $passwordHash, ':role_id' => $roleId]);
        echo "✅ Admin user created successfully!<br>";
    }
    
    echo "<br>";
    echo "<strong>Login Credentials:</strong><br>";
    echo "Username: <strong>admin</strong><br>";
    echo "Password: <strong>admin123</strong><br>";
    echo "<br>";
    echo "<a href='login.php'>Go to Login Page</a><br>";
    echo "<br>";
    echo "<small style='color: red;'>⚠️ IMPORTANT: Delete this file (reset-admin-password.php) after use for security!</small>";
    
} catch (Exception $e) {
    echo "❌ Error: " . htmlspecialchars($e->getMessage());
    error_log('Reset admin password error: ' . $e->getMessage());
}
