<?php
$pageTitle = 'Dashboard';
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/db.php';

$pdo = getDB();

// Get statistics
$stats = [];

// Total Events
$stmt = $pdo->query("SELECT COUNT(*) as count FROM events");
$stats['total_events'] = $stmt->fetch()['count'];

// Total Customers
$stmt = $pdo->query("SELECT COUNT(*) as count FROM customers");
$stats['total_customers'] = $stmt->fetch()['count'];

// Total Admin Users
$stmt = $pdo->query("SELECT COUNT(*) as count FROM admin_users WHERE is_active = 1");
$stats['total_admins'] = $stmt->fetch()['count'];

// Recent Events (last 7 days)
$stmt = $pdo->query("SELECT COUNT(*) as count FROM events WHERE created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)");
$stats['recent_events'] = $stmt->fetch()['count'];

// Recent Customers (last 7 days)
$stmt = $pdo->query("SELECT COUNT(*) as count FROM customers WHERE created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)");
$stats['recent_customers'] = $stmt->fetch()['count'];

// Events by type
$stmt = $pdo->query("SELECT event_type, COUNT(*) as count FROM events GROUP BY event_type ORDER BY count DESC LIMIT 5");
$events_by_type = $stmt->fetchAll();

// Recent customers
$stmt = $pdo->query("SELECT id, full_name, email, provider, created_at FROM customers ORDER BY created_at DESC LIMIT 5");
$recent_customers = $stmt->fetchAll();

// Recent events
$stmt = $pdo->query("SELECT id, name, event_type, start_date, created_at FROM events ORDER BY created_at DESC LIMIT 5");
$recent_events = $stmt->fetchAll();
?>

<div class="page-header">
    <h1 class="page-title">Dashboard</h1>
    <p class="page-subtitle">Welcome back, <?php echo htmlspecialchars($currentAdmin['full_name'] ?? $currentAdmin['username']); ?>!</p>
</div>

<!-- Statistics Cards -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-label">Total Events</div>
        <div class="stat-value"><?php echo number_format($stats['total_events']); ?></div>
    </div>
    
    <div class="stat-card">
        <div class="stat-label">Total Customers</div>
        <div class="stat-value"><?php echo number_format($stats['total_customers']); ?></div>
    </div>
    
    <div class="stat-card">
        <div class="stat-label">Admin Users</div>
        <div class="stat-value"><?php echo number_format($stats['total_admins']); ?></div>
    </div>
    
    <div class="stat-card">
        <div class="stat-label">Recent Events (7d)</div>
        <div class="stat-value"><?php echo number_format($stats['recent_events']); ?></div>
    </div>
</div>

<!-- Recent Events -->
<div class="card">
    <div class="card-header">
        <h2 class="card-title">Recent Events</h2>
        <a href="events.php" class="btn btn-secondary btn-sm">View All</a>
    </div>
    
    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Event Name</th>
                    <th>Type</th>
                    <th>Start Date</th>
                    <th>Created</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($recent_events)): ?>
                    <tr>
                        <td colspan="5" style="text-align: center; color: var(--text-medium);">No events found</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($recent_events as $event): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($event['name']); ?></td>
                            <td><span class="badge badge-info"><?php echo htmlspecialchars($event['event_type'] ?? 'N/A'); ?></span></td>
                            <td><?php echo $event['start_date'] ? date('M d, Y', strtotime($event['start_date'])) : 'TBA'; ?></td>
                            <td><?php echo date('M d, Y', strtotime($event['created_at'])); ?></td>
                            <td>
                                <a href="event-edit.php?id=<?php echo $event['id']; ?>" class="btn btn-secondary btn-sm">Edit</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Recent Customers -->
<div class="card">
    <div class="card-header">
        <h2 class="card-title">Recent Customers</h2>
        <a href="customers.php" class="btn btn-secondary btn-sm">View All</a>
    </div>
    
    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Provider</th>
                    <th>Joined</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($recent_customers)): ?>
                    <tr>
                        <td colspan="5" style="text-align: center; color: var(--text-medium);">No customers found</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($recent_customers as $customer): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($customer['full_name'] ?? 'N/A'); ?></td>
                            <td><?php echo htmlspecialchars($customer['email']); ?></td>
                            <td><span class="badge badge-info"><?php echo ucfirst($customer['provider']); ?></span></td>
                            <td><?php echo date('M d, Y', strtotime($customer['created_at'])); ?></td>
                            <td>
                                <a href="customer-view.php?id=<?php echo $customer['id']; ?>" class="btn btn-secondary btn-sm">View</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
