<?php
/**
 * Admin Panel Configuration
 */

// Prevent direct access
if (!defined('ADMIN_ACCESS')) {
    define('ADMIN_ACCESS', true);
}

// Include main config
require_once __DIR__ . '/../config.php';

// Admin session configuration
define('ADMIN_SESSION_NAME', 'belive_admin_session');
define('ADMIN_SESSION_LIFETIME', 7200); // 2 hours

// Start admin session
if (session_status() === PHP_SESSION_NONE) {
    session_name(ADMIN_SESSION_NAME);
    session_start();
}

// Admin base URL
define('ADMIN_BASE_URL', BASE_URL . '/admin');

// Pagination
define('ITEMS_PER_PAGE', 20);
