# Admin Panel Setup Guide

## Database Setup

First, run the SQL script to create the necessary tables:

```bash
mysql -u dbuser -p db_belive_events < ../database/create_roles_table.sql
```

Or manually execute the SQL file:
- `database/create_roles_table.sql`

This will create:
- `roles` table with default roles (Super Admin, Admin, Moderator, Viewer)
- `admin_users` table for admin panel access
- Default admin user: `admin` / `admin123` (CHANGE THIS PASSWORD!)

## Default Login Credentials

**Username:** admin  
**Password:** admin123

⚠️ **IMPORTANT:** Change the default password immediately after first login!

## Access the Admin Panel

Navigate to: `http://localhost/belive_events/admin/login.php`

## Features

### Dashboard (`index.php`)
- Overview statistics
- Recent events and customers
- Quick access to all sections

### Events Management (`events.php`)
- View all events
- Search and filter by type
- Edit/Delete events (based on permissions)
- Pagination support

### Customers Management (`customers.php`)
- View all registered customers
- Search by name/email
- Filter by OAuth provider
- View customer details
- Edit customer information

### Admin Users Management (`users.php`)
- Manage admin panel users
- Assign roles
- Activate/Deactivate users
- View last login times

### Roles Management (`roles.php`)
- View all roles
- Manage permissions
- See user count per role

## Permissions System

The admin panel uses a role-based permission system:

- **Super Admin** - Full access (`*` permission)
- **Admin** - Manage events and customers
- **Moderator** - Moderate events and customers
- **Viewer** - View only access

Permissions are checked using:
- `requirePermission('events.view')` - Require specific permission
- `hasPermission('events.edit')` - Check if user has permission

## File Structure

```
admin/
├── config.php              # Admin configuration
├── login.php              # Login page
├── logout.php            # Logout handler
├── index.php             # Dashboard
├── events.php            # Events management
├── customers.php         # Customers management
├── users.php             # Admin users management
├── roles.php             # Roles management
├── includes/
│   ├── header.php        # Common header/sidebar
│   ├── footer.php        # Common footer
│   ├── auth.php          # Authentication functions
│   └── db.php            # Database connection
├── css/
│   └── admin.css         # Skyblue theme styles
└── js/
    └── admin.js          # Admin JavaScript
```

## Theme

The admin panel uses a **whitish skyblue theme** matching the ADGM project:
- Primary color: `#4a90e2` (Sky Blue)
- Background: Light blue gradient
- Cards: White with subtle shadows
- Sidebar: White to light blue gradient

## Security Notes

1. Change default admin password immediately
2. Use strong passwords for all admin users
3. Regularly review user permissions
4. Keep the admin panel URL secure
5. Consider IP whitelisting for production

## Next Steps

1. Run the SQL script to create tables
2. Login with default credentials
3. Change admin password
4. Create additional admin users as needed
5. Configure roles and permissions
