# Stripe Payment Integration Setup Guide

## Prerequisites

1. PHP 7.4 or higher
2. Composer installed on your system
3. MySQL database with the `payments` table created

## Installation Steps

### 1. Install Stripe PHP Library

Navigate to your project directory and run:

```bash
cd /var/www/html/belive_events
composer install
```

This will install the Stripe PHP library and create the `vendor` directory.

### 2. Create Payments Table

Run the SQL script to create the payments table:

```bash
mysql -u root -p db_belive_events < database/create_payments_table.sql
```

Or manually execute the SQL from `database/create_payments_table.sql` in your MySQL client.

### 3. Configure Stripe Keys

The Stripe test keys are already configured in `config.php`. For production:

1. Get your production keys from Stripe Dashboard
2. Update `config.php` or set environment variables:
   - `STRIPE_SECRET_KEY_TEST` (or `STRIPE_SECRET_KEY_LIVE` for production)
   - `STRIPE_PUBLISHABLE_KEY_TEST` (or `STRIPE_PUBLISHABLE_KEY_LIVE` for production)

### 4. Set Up Stripe Webhook (Optional but Recommended)

For production, set up a webhook endpoint:

1. Go to Stripe Dashboard → Developers → Webhooks
2. Add endpoint: `https://yourdomain.com/belive_events/api/payment/webhook.php`
3. Select events:
   - `checkout.session.completed`
   - `payment_intent.succeeded`
   - `payment_intent.payment_failed`
4. Copy the webhook signing secret
5. Update `STRIPE_WEBHOOK_SECRET` in `config.php`

## Testing

### Test Card Numbers

Use these test card numbers in Stripe Checkout:

- **Success**: `4242 4242 4242 4242`
- **Decline**: `4000 0000 0000 0002`
- **Requires Authentication**: `4000 0025 0000 3155`

Use any future expiry date, any 3-digit CVC, and any postal code.

### Test Flow

1. Navigate to an event detail page with pricing (e.g., `http://localhost/belive_events/event-detail.html?id=candidate_35a1b01e-ef58-4808-81b8-51f3550fa864`)
2. Click "Get Tickets" button
3. You'll be redirected to Stripe Checkout
4. Use test card `4242 4242 4242 4242` to complete payment
5. After payment, you'll be redirected back with success message
6. Check the `payments` table to verify the payment record

## Payment Flow

1. User clicks "Get Tickets" button
2. Frontend calls `api/payment/create-checkout.php`
3. Backend creates Stripe Checkout Session and saves pending payment record
4. User is redirected to Stripe Checkout
5. After payment, Stripe redirects back to event page
6. Frontend verifies payment status via `api/payment/verify.php`
7. Payment record is updated in database

## Database Schema

The `payments` table stores:
- Event information (event_id, event_name)
- Stripe payment details (session_id, payment_intent_id, customer_id)
- Payment amount and currency
- Payment status (pending, completed, failed)
- Customer information (email, name)
- Ticket quantity
- Timestamps

## Troubleshooting

### "Stripe library not installed" error
- Run `composer install` in the project root

### "Database connection failed" error
- Check database credentials in `config.php`
- Ensure MySQL is running
- Verify database `db_belive_events` exists

### Payment not saving to database
- Check database table exists: `SHOW TABLES LIKE 'payments';`
- Check PHP error logs
- Verify database user has INSERT/UPDATE permissions

### Webhook not working
- Ensure webhook URL is publicly accessible
- Check webhook secret is configured correctly
- Verify SSL certificate is valid (required for webhooks)

## API Endpoints

- `POST /api/payment/create-checkout.php` - Create Stripe checkout session
- `GET /api/payment/verify.php?session_id=xxx` - Verify payment status
- `POST /api/payment/webhook.php` - Stripe webhook handler (for production)


