# Social Media Login Setup Guide

This guide will help you set up OAuth authentication with Google, Facebook, and LinkedIn.

## Database Setup

The `customers` table has been created automatically. If you need to create it manually, run:

```bash
mysql -u root -p db_belive_events < database/create_customers_table.sql
```

## OAuth App Configuration

### 1. Google OAuth Setup

1. Go to [Google Cloud Console](https://console.cloud.google.com/)
2. Create a new project or select existing one
3. Enable Google+ API
4. Go to "Credentials" → "Create Credentials" → "OAuth 2.0 Client ID"
5. Set Application type to "Web application"
6. Add Authorized redirect URIs:
   - `http://localhost/belive_events/api/auth/google-callback.php`
   - `https://yourdomain.com/belive_events/api/auth/google-callback.php` (for production)
7. Copy Client ID and Client Secret

### 2. Facebook OAuth Setup

1. Go to [Facebook Developers](https://developers.facebook.com/)
2. Create a new app
3. Add "Facebook Login" product
4. Go to Settings → Basic
5. Add Valid OAuth Redirect URIs:
   - `http://localhost/belive_events/api/auth/facebook-callback.php`
   - `https://yourdomain.com/belive_events/api/auth/facebook-callback.php` (for production)
6. Copy App ID and App Secret

### 3. LinkedIn OAuth Setup

1. Go to [LinkedIn Developers](https://www.linkedin.com/developers/)
2. Create a new app
3. In "Auth" tab, add Redirect URLs:
   - `http://localhost/belive_events/api/auth/linkedin-callback.php`
   - `https://yourdomain.com/belive_events/api/auth/linkedin-callback.php` (for production)
4. Request access to: `openid`, `profile`, `email`
5. Copy Client ID and Client Secret

## Environment Variables

Set the following environment variables or update `config.php` directly:

```bash
export GOOGLE_CLIENT_ID="your-google-client-id"
export GOOGLE_CLIENT_SECRET="your-google-client-secret"
export GOOGLE_REDIRECT_URI="http://localhost/belive_events/api/auth/google-callback.php"

export FACEBOOK_APP_ID="your-facebook-app-id"
export FACEBOOK_APP_SECRET="your-facebook-app-secret"
export FACEBOOK_REDIRECT_URI="http://localhost/belive_events/api/auth/facebook-callback.php"

export LINKEDIN_CLIENT_ID="your-linkedin-client-id"
export LINKEDIN_CLIENT_SECRET="your-linkedin-client-secret"
export LINKEDIN_REDIRECT_URI="http://localhost/belive_events/api/auth/linkedin-callback.php"
```

Or edit `config.php` and replace the empty strings with your credentials.

## Testing

1. Navigate to `http://localhost/belive_events/login.html`
2. Click on any social media login button
3. Complete the OAuth flow
4. You should be redirected back and logged in

## Features

- ✅ Google OAuth 2.0
- ✅ Facebook OAuth 2.0
- ✅ LinkedIn OAuth 2.0
- ✅ Session management
- ✅ User profile storage
- ✅ Automatic user creation/update
- ✅ Secure state token validation
- ✅ Logout functionality

## File Structure

```
belive_events/
├── api/auth/
│   ├── google.php              # Initiates Google OAuth
│   ├── google-callback.php     # Handles Google callback
│   ├── facebook.php            # Initiates Facebook OAuth
│   ├── facebook-callback.php  # Handles Facebook callback
│   ├── linkedin.php           # Initiates LinkedIn OAuth
│   ├── linkedin-callback.php   # Handles LinkedIn callback
│   ├── logout.php             # Logout endpoint
│   └── check.php              # Check auth status
├── includes/
│   └── auth.php               # Authentication helpers
├── config.php                 # Configuration
├── login.html                 # Login page
└── auth.js                    # Client-side auth handling
```

## Notes

- Make sure your redirect URIs match exactly in both the OAuth provider settings and your config
- For production, update all redirect URIs to use HTTPS
- The `customers` table stores user information securely
- Access tokens are stored but can be removed if not needed for API calls
