# OAuth Configuration Status

## ✅ Configured Providers

### Facebook OAuth
- **App ID:** 886686760452519
- **App Secret:** 92ab10e4a51d19f4675f52da78390f3f
- **Status:** ✅ Configured
- **Redirect URI:** `http://localhost/belive_events/api/auth/facebook-callback.php`

**Next Steps:**
1. Go to [Facebook Developers](https://developers.facebook.com/apps/886686760452519/settings/basic/)
2. Add the redirect URI in "Valid OAuth Redirect URIs":
   ```
   http://localhost/belive_events/api/auth/facebook-callback.php
   ```
3. For production, also add your production URL

### LinkedIn OAuth
- **Client ID:** 86027avvd0ox4e
- **Client Secret:** WPL_AP1.qUfgCcXnV2VihPWm.tWILmA==
- **Status:** ✅ Configured
- **Redirect URI:** `http://localhost/belive_events/api/auth/linkedin-callback.php`

**Next Steps:**
1. Go to [LinkedIn Developers](https://www.linkedin.com/developers/apps)
2. Select your app (Client ID: 86027avvd0ox4e)
3. Go to "Auth" tab
4. Add redirect URL:
   ```
   http://localhost/belive_events/api/auth/linkedin-callback.php
   ```
5. Ensure scopes are enabled: `openid`, `profile`, `email`

## ⚠️ Pending Configuration

### Google OAuth
- **Status:** ⚠️ Needs Setup
- **Action Required:** Create OAuth credentials in Google Cloud Console

**Setup Instructions:**
See `GOOGLE_OAUTH_SETUP.md` for detailed step-by-step guide.

**Quick Steps:**
1. Go to https://console.cloud.google.com/
2. Create/Select project
3. Enable Google+ API or People API
4. Configure OAuth consent screen
5. Create OAuth 2.0 Client ID
6. Add redirect URI: `http://localhost/belive_events/api/auth/google-callback.php`
7. Copy Client ID and Secret
8. Update `config.php` with the credentials

## Testing

After configuration, test each provider:

1. **Facebook:** 
   - Go to http://localhost/belive_events/login.html
   - Click "Continue with Facebook"
   - Should redirect to Facebook login

2. **LinkedIn:**
   - Go to http://localhost/belive_events/login.html
   - Click "Continue with LinkedIn"
   - Should redirect to LinkedIn login

3. **Google:**
   - After setting up credentials
   - Go to http://localhost/belive_events/login.html
   - Click "Continue with Google"
   - Should redirect to Google login

## Production Setup

For production deployment:

1. Update all redirect URIs to use HTTPS:
   ```
   https://yourdomain.com/belive_events/api/auth/facebook-callback.php
   https://yourdomain.com/belive_events/api/auth/linkedin-callback.php
   https://yourdomain.com/belive_events/api/auth/google-callback.php
   ```

2. Update `BASE_URL` in `config.php`:
   ```php
   define('BASE_URL', 'https://yourdomain.com/belive_events');
   ```

3. Update redirect URIs in each provider's console:
   - Facebook: App Settings → Valid OAuth Redirect URIs
   - LinkedIn: Auth tab → Redirect URLs
   - Google: Credentials → Authorized redirect URIs

4. Consider using environment variables for production:
   ```php
   define('FACEBOOK_APP_ID', getenv('FACEBOOK_APP_ID') ?: '886686760452519');
   ```

## Security Notes

- ✅ Credentials are stored in `config.php` (not in version control recommended)
- ✅ OAuth state tokens prevent CSRF attacks
- ✅ Passwords are hashed using bcrypt
- ⚠️ For production, consider using environment variables or secure config files
- ⚠️ Never commit credentials to public repositories
