# Google OAuth Setup Instructions

## Step-by-Step Guide

### 1. Go to Google Cloud Console
Visit: https://console.cloud.google.com/

### 2. Create or Select a Project
- Click on the project dropdown at the top
- Click "New Project" or select an existing project
- Give it a name (e.g., "beLIVE Events")

### 3. Enable Google+ API
- Go to "APIs & Services" → "Library"
- Search for "Google+ API" or "People API"
- Click on it and click "Enable"

### 4. Configure OAuth Consent Screen
- Go to "APIs & Services" → "OAuth consent screen"
- Choose "External" (unless you have a Google Workspace)
- Fill in the required information:
  - App name: beLIVE Events
  - User support email: your email
  - Developer contact: your email
- Click "Save and Continue"
- Add scopes: `email`, `profile`, `openid`
- Click "Save and Continue"
- Add test users if needed (for testing)
- Click "Save and Continue"

### 5. Create OAuth 2.0 Credentials
- Go to "APIs & Services" → "Credentials"
- Click "Create Credentials" → "OAuth 2.0 Client ID"
- Application type: "Web application"
- Name: beLIVE Events Web Client
- Authorized redirect URIs:
  ```
  http://localhost/belive_events/api/auth/google-callback.php
  ```
  (For production, also add your production URL)

### 6. Copy Credentials
- After creating, you'll see:
  - **Client ID**: Copy this
  - **Client Secret**: Copy this

### 7. Update config.php
Update these values in `/var/www/html/belive_events/config.php`:

```php
define('GOOGLE_CLIENT_ID', 'YOUR_CLIENT_ID_HERE');
define('GOOGLE_CLIENT_SECRET', 'YOUR_CLIENT_SECRET_HERE');
```

### 8. Test
- Go to: http://localhost/belive_events/login.html
- Click "Continue with Google"
- You should be redirected to Google login
- After login, you'll be redirected back to the site

## Important Notes

- **Redirect URIs must match exactly** - including http/https and trailing slashes
- For production, update the redirect URI to your production domain
- Keep your Client Secret secure - never commit it to public repositories
- The OAuth consent screen may need verification for production use

## Troubleshooting

**Error: "redirect_uri_mismatch"**
- Check that the redirect URI in Google Console matches exactly with `GOOGLE_REDIRECT_URI` in config.php

**Error: "access_denied"**
- Make sure you've added the required scopes in OAuth consent screen
- Check that test users are added if app is in testing mode

**Error: "invalid_client"**
- Verify Client ID and Client Secret are correct
- Make sure there are no extra spaces or characters
