# Admin Password Fix

## Issue
The default admin password hash in the database doesn't match "admin123".

## Solution Options

### Option 1: Use the Reset Script (Easiest)

1. Navigate to:
   ```
   https://recognizer.multitvsolution.com/events/admin/reset-admin-password.php?key=reset_admin_2025
   ```

2. This will:
   - Create/update the admin user
   - Set password to `admin123`
   - Show you the login credentials

3. **IMPORTANT:** Delete `reset-admin-password.php` after use for security!

### Option 2: Run SQL Script

Run this SQL command in your database:

```sql
UPDATE admin_users 
SET password_hash = '$2y$10$JHwCGoQxPux7t/6tyIpGO.zriL3rjVgpb7zDQp.PcZkCBwyKqbOaK'
WHERE username = 'admin';
```

Or run the SQL file:
```bash
mysql -u dbuser -p db_belive_events < database/fix_admin_password.sql
```

### Option 3: Create New Admin User via SQL

If admin user doesn't exist:

```sql
INSERT INTO admin_users (username, email, password_hash, full_name, role_id, is_active)
VALUES ('admin', 'admin@belive.com', '$2y$10$JHwCGoQxPux7t/6tyIpGO.zriL3rjVgpb7zDQp.PcZkCBwyKqbOaK', 'System Administrator', 1, 1);
```

## Default Credentials

After fixing:
- **Username:** `admin`
- **Password:** `admin123`

## Change Password After Login

Once logged in, you should change the password immediately for security.

## Verification

To verify the password works:
1. Go to: https://recognizer.multitvsolution.com/events/admin/login.php
2. Enter username: `admin`
3. Enter password: `admin123`
4. You should be logged in successfully
