<div align="center">

<img src="https://hievents-public.s3.us-west-1.amazonaws.com/website/github-banner.png?v=1" alt="Hi.Events - Nền tảng Bán vé Sự kiện Mã nguồn Mở" width="100%">

# Hi.Events

### Nền tảng bán vé và quản lý sự kiện mã nguồn mở

Bán vé trực tuyến cho hội nghị, sự kiện giải trí, hòa nhạc, đêm câu lạc bộ, hội thảo và lễ hội.
Tự lưu trữ hoặc đám mây. Sự kiện của bạn, thương hiệu của bạn, dữ liệu của bạn.

[Dùng thử Cloud →](https://app.hi.events/auth/register?utm_source=gh-readme) · [Demo trực tiếp](https://app.hi.events/event/2/hievents-conference-2030?utm_source=gh-readme) · [Tài liệu](https://hi.events/docs?utm_source=gh-readme) · [Website](https://hi.events?utm_source=gh-readme)

[![License: AGPL v3](https://img.shields.io/badge/License-AGPL_v3-blue.svg)](https://github.com/HiEventsDev/Hi.Events/blob/develop/LICENCE)
[![GitHub Release](https://img.shields.io/github/v/release/HiEventsDev/hi.events?include_prereleases)](https://github.com/HiEventsDev/hi.events/releases)
[![Run Unit Tests](https://github.com/HiEventsDev/hi.events/actions/workflows/unit-tests.yml/badge.svg?event=push)](https://github.com/HiEventsDev/hi.events/actions/workflows/unit-tests.yml)
[![Docker Pulls](https://img.shields.io/docker/pulls/daveearley/hi.events-all-in-one)](https://hub.docker.com/r/daveearley/hi.events-all-in-one)

<a href="https://trendshift.io/repositories/10563" target="_blank">
  <img src="https://trendshift.io/api/badge/repositories/10563" alt="HiEventsDev%2Fhi.events | Trendshift" width="250" height="55"/>
</a>

<p>
<a href="README.de.md">Deutsch</a> · <a href="README.pt.md">Português</a> · <a href="README.pt-br.md">Português (Brasil)</a> · <a href="README.fr.md">Français</a> · <a href="README.it.md">Italiano</a> · <a href="README.nl.md">Nederlands</a> · <a href="README.es.md">Español</a> · <a href="README.zh-cn.md">中文</a> · <a href="README.zh-hk.md">繁體中文</a> · <a href="README.ja.md">日本語</a> · <a href="README.vi.md">Tiếng Việt</a> · <a href="README.tr.md">Türkçe</a> · <a href="README.hu.md">Magyar</a> · <a href="README.pl.md">Polski</a>
</p>

<br>

## Tại sao chọn Hi.Events?

Hầu hết các nền tảng bán vé tính phí cho mỗi vé và khóa dữ liệu của bạn vào hệ sinh thái của họ. **Hi.Events là một giải pháp thay thế mã nguồn mở hiện đại cho Eventbrite, Tickettailor, Dice.fm, và các nền tảng bán vé khác** dành cho những người tổ chức muốn kiểm soát hoàn toàn thương hiệu, thanh toán, dữ liệu và cơ sở hạ tầng.

Được xây dựng cho người quảng bá giải trí đêm, người tổ chức lễ hội, địa điểm sự kiện, nhóm cộng đồng và người tổ chức hội nghị.

<br>

<img alt="Bảng điều khiển Hi.Events" src="https://hievents-public.s3.us-west-1.amazonaws.com/website/github-screenshot.png"/>

<br>

## Tính năng

<table>
<tr>
<td width="50%" valign="top">

### 🎟️ Bán vé & Doanh số

- Các loại vé linh hoạt (miễn phí, trả phí, quyên góp, phân tầng)
- Vé ẩn và khóa bằng mã khuyến mãi
- Mã khuyến mãi và truy cập bán trước
- Sản phẩm bổ sung (hàng hóa, nâng cấp, phụ kiện)
- Danh mục sản phẩm để tổ chức
- Hỗ trợ đầy đủ thuế và phí (VAT, phí dịch vụ)
- Quản lý sức chứa và giới hạn chia sẻ

</td>
<td width="50%" valign="top">

### 🎨 Thương hiệu & Tùy chỉnh

- Thanh toán đẹp, tối ưu hóa chuyển đổi
- Thiết kế vé PDF có thể tùy chỉnh
- Trang chủ người tổ chức có thương hiệu
- Trình tạo trang sự kiện kéo thả
- Widget vé có thể nhúng
- Công cụ SEO (thẻ meta, Open Graph)

</td>
</tr>
<tr>
<td width="50%" valign="top">

### 👥 Quản lý Người tham dự

- Câu hỏi thanh toán tùy chỉnh
- Tìm kiếm, lọc và xuất nâng cao (CSV/XLSX)
- Hoàn tiền toàn bộ và một phần
- Gửi tin nhắn hàng loạt theo loại vé
- Check-in mã QR với nhật ký quét
- Danh sách check-in được kiểm soát truy cập

</td>
<td width="50%" valign="top">

### 📊 Phân tích & Tăng trưởng

- Bảng điều khiển doanh số thời gian thực
- Theo dõi đối tác liên kết và giới thiệu
- Báo cáo nâng cao (doanh số, thuế, khuyến mãi)
- Webhooks (Zapier, Make, CRMs)

</td>
</tr>
<tr>
<td colspan="2" valign="top">

### ⚙️ Vận hành

Vai trò và quyền đa người dùng · Thanh toán tức thì Stripe Connect · Phương thức thanh toán ngoại tuyến · Hỗ trợ sự kiện ngoại tuyến ·
Lập hóa đơn tự động · Lưu trữ sự kiện · Hỗ trợ đa ngôn ngữ · API REST đầy đủ

</td>
</tr>
</table>

<br>

## So sánh

| Tính năng                                | Hi.Events | Eventbrite | Tickettailor | Dice    |
|:-----------------------------------------|:----------|:-----------|:-------------|:--------|
| Tùy chọn tự lưu trữ                      | ✅         | ❌          | ❌            | ❌       |
| Mã nguồn mở                              | ✅         | ❌          | ❌            | ❌       |
| Không có phí mỗi vé (tự lưu trữ)         | ✅         | ❌          | ❌            | ❌       |
| Thương hiệu tùy chỉnh hoàn toàn          | ✅         | Giới hạn   | ✅            | Giới hạn |
| Theo dõi đối tác liên kết                | ✅         | ✅          | ❌            | ❌       |
| Truy cập API                             | ✅         | ✅          | ✅            | Giới hạn |
| Sở hữu dữ liệu của bạn                   | ✅         | ❌          | ❌            | ❌       |

<br>

## Bắt đầu nhanh

### Triển khai Một cú nhấp chuột

[![Deploy on DigitalOcean](https://www.deploytodo.com/do-btn-blue.svg)](https://github.com/HiEventsDev/hi.events-digitalocean)
[![Deploy to Render](https://render.com/images/deploy-to-render-button.svg)](https://github.com/HiEventsDev/hi.events-render.com)
[![Deploy on Railway](https://railway.app/button.svg)](https://railway.app/template/8CGKmu?referralCode=KvSr11)
[![Deploy on Zeabur](https://zeabur.com/button.svg)](https://zeabur.com/templates/8DIRY6)

### Docker

```bash
git clone git@github.com:HiEventsDev/hi.events.git
cd hi.events/docker/all-in-one

# Tạo khóa (Linux/macOS)
echo "APP_KEY=base64:$(openssl rand -base64 32)" >> .env
echo "JWT_SECRET=$(openssl rand -base64 32)" >> .env

docker compose up -d
```

> [!TIP]
> **Người dùng Windows:** Xem `./docker/all-in-one/README.md` để biết hướng dẫn tạo khóa.

Mở `http://localhost:8123` và tạo tài khoản của bạn.

📖 [Hướng dẫn cài đặt đầy đủ](https://hi.events/docs/getting-started?utm_source=gh-readme)

<br>

## Hi.Events Cloud

Không muốn tự lưu trữ? **[Hi.Events Cloud](https://app.hi.events/auth/register?utm_source=gh-readme)** là một tùy chọn được quản lý hoàn toàn với không cần thiết lập, cập nhật tự động và cơ sở hạ tầng được quản lý.

[Bắt đầu →](https://app.hi.events/auth/register?utm_source=gh-readme)

<br>

## Tài liệu

| Tài nguyên      | Liên kết                                                                                      |
|:----------------|:----------------------------------------------------------------------------------------------|
| Bắt đầu         | [hi.events/docs/getting-started](https://hi.events/docs/getting-started?utm_source=gh-readme) |
| Cấu hình        | [hi.events/docs/configuration](https://hi.events/docs/configuration?utm_source=gh-readme)     |
| Tham chiếu API  | [hi.events/docs/api](https://hi.events/docs/api?utm_source=gh-readme)                         |
| Webhooks        | [hi.events/docs/webhooks](https://hi.events/docs/webhooks?utm_source=gh-readme)               |

<br>

## Đóng góp

Chúng tôi hoan nghênh các đóng góp. Xem [hướng dẫn đóng góp](CONTRIBUTING.md) để biết chi tiết.

<br>

## Hỗ trợ

📖 [Tài liệu](https://hi.events/docs?utm_source=gh-readme) · 📧 [hello@hi.events](mailto:hello@hi.events) ·
🐛 [GitHub Issues](https://github.com/HiEventsDev/hi.events/issues)

<br>

## Nhật ký thay đổi

Luôn cập nhật với các tính năng mới và cải tiến trên
[trang phát hành](https://github.com/HiEventsDev/hi.events/releases).

<br>

## Giấy phép

Hi.Events được cấp phép theo **AGPL-3.0 với các điều khoản bổ sung**. Cấp phép thương mại
có sẵn. [Tìm hiểu thêm](https://hi.events/licensing).

<br>

<div align="center">

**[Website](https://hi.events)** · **[Tài liệu](https://hi.events/docs)** · *
*[Twitter/X](https://x.com/HiEventsTickets)**

Được tạo ra với ☘️ tại Ireland

</div>
