<div align="center">

<img src="https://hievents-public.s3.us-west-1.amazonaws.com/website/github-banner.png?v=1" alt="Hi.Events - Otwarta platforma sprzedaży biletów do wydarzeń" width="100%">

# Hi.Events

### Otwarta platforma do zarządzania wydarzeniami i sprzedaży biletów online

Sprzedawaj bilety online na konferencje, imprezy nocne, koncerty, imprezy klubowe, warsztaty i festiwale.  
Samodzielnie hostowana lub w chmurze. Twoje wydarzenia, Twoja marka, Twoje dane.

[Wypróbuj w chmurze →](https://app.hi.events/auth/register?utm_source=gh-readme) · [Demo na żywo](https://app.hi.events/event/2/hievents-conference-2030?utm_source=gh-readme) · [Dokumentacja](https://hi.events/docs?utm_source=gh-readme) · [Strona internetowa](https://hi.events?utm_source=gh-readme)

[![Licencja: AGPL v3](https://img.shields.io/badge/License-AGPL_v3-blue.svg)](https://github.com/HiEventsDev/Hi.Events/blob/develop/LICENCE)
[![Wydanie GitHub](https://img.shields.io/github/v/release/HiEventsDev/hi.events?include_prereleases)](https://github.com/HiEventsDev/hi.events/releases)
[![Testy jednostkowe](https://github.com/HiEventsDev/hi.events/actions/workflows/unit-tests.yml/badge.svg?event=push)](https://github.com/HiEventsDev/hi.events/actions/workflows/unit-tests.yml)
[![Pobrania Docker](https://img.shields.io/docker/pulls/daveearley/hi.events-all-in-one)](https://hub.docker.com/r/daveearley/hi.events-all-in-one)

<a href="https://trendshift.io/repositories/10563" target="_blank">
  <img src="https://trendshift.io/api/badge/repositories/10563" alt="HiEventsDev%2Fhi.events | Trendshift" width="250" height="55"/>
</a>

<p>
<a href="README.de.md">Deutsch</a> · <a href="README.pt.md">Português</a> · <a href="README.fr.md">Français</a> · <a href="README.it.md">Italiano</a> · <a href="README.nl.md">Nederlands</a> · <a href="README.es.md">Español</a> · <a href="README.zh-cn.md">中文</a> · <a href="README.zh-hk.md">繁體中文</a> · <a href="README.ja.md">日本語</a> · <a href="README.vi.md">Tiếng Việt</a> · <a href="README.tr.md">Türkçe</a> · <a href="README.hu.md">Magyar</a> · <a href="README.pl.md">Polski</a>
</p>

</div>

<br>

## Dlaczego Hi.Events?

Większość platform do sprzedaży biletów pobiera opłaty za bilet i zamyka Twoje dane w swoim ekosystemie. **Hi.Events to nowoczesna, otwarta alternatywa dla Eventbrite, Tickettailor, Dice.fm i innych platform** dla organizatorów, którzy chcą pełną kontrolę nad marką, procesem checkout, danymi i infrastrukturą.

Stworzony dla promotorów życia nocnego, organizatorów festiwali, sal koncertowych, grup społecznych i gospodarzy konferencji.

<br>

<img alt="Panel Hi.Events" src="https://hievents-public.s3.us-west-1.amazonaws.com/website/github-screenshot.png"/>

<br>

## 📚 Wprowadzenie

<a href="https://hi.events">Hi.Events</a> to bogata w funkcje, samodzielnie hostowana platforma do zarządzania wydarzeniami i sprzedaży biletów online. Pomaga w sprzedaży biletów na wszelkiego rodzaju wydarzenia — od konferencji i warsztatów, po koncerty i imprezy klubowe. Hi.Events zapewnia wszystkie narzędzia potrzebne do tworzenia, zarządzania i monetyzacji wydarzeń w prosty sposób.

<img alt="Panel sprzedaży biletów Hi.Events" src="https://hievents-public.s3.us-west-1.amazonaws.com/website/github-readme-screenshot.png"/>
<div align="center">
<caption>Wygenerowano przy użyciu <a href="https://screenshot.rocks?utm_source=hi.events-readme">Screenshot Rocks</a></caption>
</div>

## ⚡ Szybkie wdrożenie

Zacznij w kilka minut dzięki gotowym opcjom wdrożeniowym jednym kliknięciem:

[![Deploy on DigitalOcean](https://www.deploytodo.com/do-btn-blue.svg)](https://github.com/HiEventsDev/hi.events-digitalocean)
[![Deploy to Render](https://render.com/images/deploy-to-render-button.svg)](https://github.com/HiEventsDev/hi.events-render.com)
[![Deploy on Railway](https://railway.app/button.svg)](https://railway.app/template/8CGKmu?referralCode=KvSr11)
[![Deploy on Zeabur](https://zeabur.com/button.svg)](https://zeabur.com/templates/8DIRY6)

## ☁️ Hi.Events Cloud

Szukasz szybszego sposobu na rozpoczęcie pracy?

**[Hi.Events Cloud](https://app.hi.events/auth/register?utm_source=gh-readme&utm_content=try-cloud-section)** to w pełni zarządzana wersja Hi.Events — bez konfiguracji, bez serwerów, natychmiastowy dostęp do wszystkich funkcji.

- ✅ Brak potrzeby instalacji  
- 🔐 Bezpieczna, skalowalna infrastruktura  
- 🚀 Automatyczne aktualizacje i nowe funkcje  
- 🧰 Idealne dla organizatorów, którzy chcą skupić się na wydarzeniu, a nie na infrastrukturze  

Utwórz konto w kilka sekund i zacznij korzystać z platformy:

👉 [Wypróbuj Hi.Events Cloud](https://app.hi.events/auth/register?utm_source=gh-readme&utm_content=try-cloud-section)

## Funkcje

<table>
<tr>
<td width="50%" valign="top">

### 🎟️ Sprzedaż biletów

- Elastyczne typy biletów (darmowe, płatne, darowizny, warstwowe)
- Ukryte i zablokowane bilety za kodami promocyjnymi
- Kody promocyjne i dostęp do przedsprzedaży
- Dodatki do produktów (towary, ulepszenia, ekstra)
- Kategorie produktów do organizacji
- Pełna obsługa podatków i opłat (VAT, opłaty serwisowe)
- Zarządzanie pojemnością i wspólne limity

</td>
<td width="50%" valign="top">

### 🎨 Branding i dostosowanie

- Piękny, zoptymalizowany do konwersji checkout
- Projekty biletów PDF możliwe do dostosowania
- Strona główna organizatora z marką
- Kreator stron zdarzeń z drag-and-drop
- Osadzalny widget biletów
- Narzędzia SEO (meta tagi, Open Graph)

</td>
</tr>
<tr>
<td width="50%" valign="top">

### 👥 Zarządzanie uczestnikami

- Niestandardowe pytania dotyczące checkout
- Zaawansowane wyszukiwanie, filtrowanie i eksport (CSV/XLSX)
- Pełne i częściowe zwroty
- Wiadomości masowe wg typu biletu
- Odprawa z kodem QR z logami skanów
- Listy odpraw z kontrolą dostępu

</td>
<td width="50%" valign="top">

### 📊 Analityka i wzrost

- Pulpit sprzedaży w czasie rzeczywistym
- Śledzenie afiliacyjne i polecające
- Zaawansowane raporty (sprzedaż, podatki, promocje)
- Webhooks (Zapier, Make, CRM)

</td>
</tr>
<tr>
<td colspan="2" valign="top">

### ⚙️ Operacje

Role i uprawnienia wielu użytkowników · Natychmiastowe wypłaty przez Stripe Connect · Metody płatności offline · Wsparcie dla zdarzeń offline ·
Automatyczne fakturowanie · Archiwum zdarzeń · Wsparcie wielojęzyczne · Pełny REST API

</td>
</tr>
</table>

<br>

## Porównanie

| Funkcja                          | Hi.Events | Eventbrite | Tickettailor | Dice    |
|:---------------------------------|:----------|:-----------|:-------------|:--------|
| Opcja samodzielnie hostowana     | ✅         | ❌          | ❌            | ❌       |
| Otwarte źródło                   | ✅         | ❌          | ❌            | ❌       |
| Brak opłat za bilet (samodzielnie hostowane) | ✅         | ❌          | ❌            | ❌       |
| Pełne dostosowanie marki         | ✅         | Ograniczone | ✅            | Ograniczone |
| Śledzenie afiliacyjne            | ✅         | ✅          | ❌            | ❌       |
| Dostęp do API                    | ✅         | ✅          | ✅            | Ograniczone |
| Posiadaj swoje dane              | ✅         | ❌          | ❌            | ❌       |

<br>

## Szybki start

### Wdrażanie jednym kliknięciem

[![Deploy on DigitalOcean](https://www.deploytodo.com/do-btn-blue.svg)](https://github.com/HiEventsDev/hi.events-digitalocean)
[![Deploy to Render](https://render.com/images/deploy-to-render-button.svg)](https://github.com/HiEventsDev/hi.events-render.com)
[![Deploy on Railway](https://railway.app/button.svg)](https://railway.app/template/8CGKmu?referralCode=KvSr11)
[![Deploy on Zeabur](https://zeabur.com/button.svg)](https://zeabur.com/templates/8DIRY6)

### Docker

```bash
git clone git@github.com:HiEventsDev/hi.events.git
cd hi.events/docker/all-in-one

# Wygeneruj klucze (Linux/macOS)
echo "APP_KEY=base64:$(openssl rand -base64 32)" >> .env
echo "JWT_SECRET=$(openssl rand -base64 32)" >> .env

docker compose up -d
```

> [!TIP]
> **Użytkownicy Windows:** Zobacz `./docker/all-in-one/README.md` aby uzyskać instrukcje generowania kluczy.

Otwórz `http://localhost:8123` i utwórz swoje konto.

📖 [Pełny przewodnik instalacji](https://hi.events/docs/getting-started?utm_source=gh-readme)

<br>

## Hi.Events Cloud

Wolisz nie samodzielnie hostować? **[Hi.Events Cloud](https://app.hi.events/auth/register?utm_source=gh-readme)** to w pełni zarządzana opcja z zerową konfiguracją, automatycznymi aktualizacjami i zarządzaną infrastrukturą.

[Zacznij →](https://app.hi.events/auth/register?utm_source=gh-readme)

<br>

## Wkład

Zapraszamy wkład. Szczegóły znajdują się w [przewodniku wkładu](CONTRIBUTING.md).

<br>

## Wsparcie

📖 [Dokumentacja](https://hi.events/docs?utm_source=gh-readme) · 📧 [hello@hi.events](mailto:hello@hi.events) ·
🐛 [GitHub Issues](https://github.com/HiEventsDev/hi.events/issues)

<br>

## Dziennik zmian

Bądź na bieżąco z nowymi funkcjami i ulepszeniami na
[stronie wydań](https://github.com/HiEventsDev/hi.events/releases).

<br>

## Licencja

Hi.Events jest objęty licencją **AGPL-3.0 z dodatkowymi warunkami**. Dostępna licencja komercyjna.
[Dowiedz się więcej](https://hi.events/licensing).

<br>

<div align="center">

**[Strona internetowa](https://hi.events)** · **[Dokumentacja](https://hi.events/docs)** · **[Twitter/X](https://x.com/HiEventsTickets)**

Wykonane z ☘️ w Irlandii

</div>