<div align="center">

<img src="https://hievents-public.s3.us-west-1.amazonaws.com/website/github-banner.png?v=1" alt="Hi.Events - Nyílt forráskódú eseménykezelő és jegyértékesítő platform" width="100%">

# Hi.Events

### Nyílt forráskódú eseménykezelő és jegyértékesítő platform

Adjon el jegyeket online konferenciákra, szórakozóhelyi eseményekre, koncertekre, klubestekre, workshopokra és fesztiválokra.
Saját szerveren vagy felhőben. Az Ön eseményei, az Ön márkája, az Ön adatai.

[Próbálja ki a felhőt →](https://app.hi.events/auth/register?utm_source=gh-readme) · [Élő demó](https://app.hi.events/event/2/hievents-conference-2030?utm_source=gh-readme) · [Dokumentáció](https://hi.events/docs?utm_source=gh-readme) · [Weboldal](https://hi.events?utm_source=gh-readme)

[![License: AGPL v3](https://img.shields.io/badge/License-AGPL_v3-blue.svg)](https://github.com/HiEventsDev/Hi.Events/blob/develop/LICENCE)
[![GitHub Release](https://img.shields.io/github/v/release/HiEventsDev/hi.events?include_prereleases)](https://github.com/HiEventsDev/hi.events/releases)
[![Run Unit Tests](https://github.com/HiEventsDev/hi.events/actions/workflows/unit-tests.yml/badge.svg?event=push)](https://github.com/HiEventsDev/hi.events/actions/workflows/unit-tests.yml)
[![Docker Pulls](https://img.shields.io/docker/pulls/daveearley/hi.events-all-in-one)](https://hub.docker.com/r/daveearley/hi.events-all-in-one)

<a href="https://trendshift.io/repositories/10563" target="_blank">
  <img src="https://trendshift.io/api/badge/repositories/10563" alt="HiEventsDev%2Fhi.events | Trendshift" width="250" height="55"/>
</a>

<p>
<a href="README.de.md">Deutsch</a> · <a href="README.pt.md">Português</a> · <a href="README.fr.md">Français</a> · <a href="README.it.md">Italiano</a> · <a href="README.nl.md">Nederlands</a> · <a href="README.es.md">Español</a> · <a href="README.zh-cn.md">中文</a> · <a href="README.zh-hk.md">繁體中文</a> · <a href="README.ja.md">日本語</a> · <a href="README.vi.md">Tiếng Việt</a> · <a href="README.tr.md">Türkçe</a> · <a href="README.hu.md">Magyar</a> · <a href="README.pl.md">Polski</a>
</p>

</div>

<br>

## Miért a Hi.Events?

A legtöbb jegyértékesítő platform jegyenkénti díjakat számít fel, és az adatait a saját ökoszisztémájába zárja. **A Hi.Events egy modern,
nyílt forráskódú alternatíva az Eventbrite, Tickettailor, Dice.fm és más jegyértékesítő platformokkal szemben** azoknak a szervezőknek, akik
teljes kontrollt szeretnének a márkaépítés, a fizetés, az adatok és az infrastruktúra felett.

Készült szórakozóhelyi promóterek, fesztiválszervezők, helyszínek, közösségi csoportok és konferenciaszervezők számára.

<br>

<img alt="Hi.Events irányítópult" src="https://hievents-public.s3.us-west-1.amazonaws.com/website/github-screenshot.png"/>

<br>

## Funkciók

<table>
<tr>
<td width="50%" valign="top">

### 🎟️ Jegyértékesítés és eladás

- Rugalmas jegytípusok (ingyenes, fizetős, adomány, lépcsőzetes)
- Rejtett és promóciós kódokkal zárolt jegyek
- Promóciós kódok és előértékesítési hozzáférés
- Termék kiegészítők (merchandising, frissítések, extrák)
- Termékkategóriák a rendszerezéshez
- Teljes adó- és díjtámogatás (ÁFA, szolgáltatási díjak)
- Kapacitáskezelés és megosztott korlátok

</td>
<td width="50%" valign="top">

### 🎨 Márkaépítés és testreszabás

- Gyönyörű, konverzióra optimalizált fizetés
- Testreszabható PDF jegytervezés
- Márkás szervező honlap
- Húzd és ejtsd eseményoldal-szerkesztő
- Beágyazható jegy widget
- SEO eszközök (meta címkék, Open Graph)

</td>
</tr>
<tr>
<td width="50%" valign="top">

### 👥 Résztvevő kezelés

- Egyéni fizetési kérdések
- Fejlett keresés, szűrés és exportálás (CSV/XLSX)
- Teljes és részleges visszatérítések
- Tömeges üzenetküldés jegytípus szerint
- QR kódos bejelentkezés szkennelési naplókkal
- Hozzáféréssel szabályozott bejelentkezési listák

</td>
<td width="50%" valign="top">

### 📊 Elemzés és növekedés

- Valós idejű értékesítési irányítópult
- Affiliate és ajánlási követés
- Fejlett jelentések (értékesítés, adó, promóciók)
- Webhookok (Zapier, Make, CRM-ek)

</td>
</tr>
<tr>
<td colspan="2" valign="top">

### ⚙️ Műveletek

Többfelhasználós szerepek és jogosultságok · Stripe Connect azonnali kifizetések · Offline fizetési módok · Offline eseménytámogatás ·
Automatikus számlázás · Eseményarchívum · Többnyelvű támogatás · Teljes REST API

</td>
</tr>
</table>

<br>

## Összehasonlítás

| Funkció                                   | Hi.Events | Eventbrite | Tickettailor | Dice     |
|:------------------------------------------|:----------|:-----------|:-------------|:---------|
| Saját szerveren futtatható opció          | ✅         | ❌          | ❌            | ❌        |
| Nyílt forráskódú                          | ✅         | ❌          | ❌            | ❌        |
| Nincs jegyenkénti díj (saját szerveren)   | ✅         | ❌          | ❌            | ❌        |
| Teljes egyéni márkaépítés                 | ✅         | Korlátozott| ✅            | Korlátozott |
| Affiliate követés                         | ✅         | ✅          | ❌            | ❌        |
| API hozzáférés                            | ✅         | ✅          | ✅            | Korlátozott |
| Saját adatok                              | ✅         | ❌          | ❌            | ❌        |

<br>

## Gyors kezdés

### Egy kattintásos telepítés

[![Deploy on DigitalOcean](https://www.deploytodo.com/do-btn-blue.svg)](https://github.com/HiEventsDev/hi.events-digitalocean)
[![Deploy to Render](https://render.com/images/deploy-to-render-button.svg)](https://github.com/HiEventsDev/hi.events-render.com)
[![Deploy on Railway](https://railway.app/button.svg)](https://railway.app/template/8CGKmu?referralCode=KvSr11)
[![Deploy on Zeabur](https://zeabur.com/button.svg)](https://zeabur.com/templates/8DIRY6)

### Docker

```bash
git clone git@github.com:HiEventsDev/hi.events.git
cd hi.events/docker/all-in-one

# Kulcsok generálása (Linux/macOS)
echo "APP_KEY=base64:$(openssl rand -base64 32)" >> .env
echo "JWT_SECRET=$(openssl rand -base64 32)" >> .env

docker compose up -d
```

> [!TIP]
> **Windows felhasználók:** A kulcsgenerálási utasításokért lásd: `./docker/all-in-one/README.md`

Nyissa meg a `http://localhost:8123` címet és hozza létre fiókját.

📖 [Teljes telepítési útmutató](https://hi.events/docs/getting-started?utm_source=gh-readme)

<br>

## Hi.Events Cloud

Inkább nem szeretne saját szervert üzemeltetni? A **[Hi.Events Cloud](https://app.hi.events/auth/register?utm_source=gh-readme)** egy teljesen
felügyelt megoldás nulla beállítással, automatikus frissítésekkel és felügyelt infrastruktúrával.

[Kezdje el →](https://app.hi.events/auth/register?utm_source=gh-readme)

<br>

## Dokumentáció

| Forrás          | Link                                                                                          |
|:----------------|:----------------------------------------------------------------------------------------------|
| Első lépések    | [hi.events/docs/getting-started](https://hi.events/docs/getting-started?utm_source=gh-readme) |
| Konfiguráció    | [hi.events/docs/configuration](https://hi.events/docs/configuration?utm_source=gh-readme)     |
| API referencia  | [hi.events/docs/api](https://hi.events/docs/api?utm_source=gh-readme)                         |
| Webhookok       | [hi.events/docs/webhooks](https://hi.events/docs/webhooks?utm_source=gh-readme)               |

<br>

## Közreműködés

Szívesen fogadunk közreműködéseket. A részletekért lásd a [közreműködési útmutatót](CONTRIBUTING.md).

<br>

## Támogatás

📖 [Dokumentáció](https://hi.events/docs?utm_source=gh-readme) · 📧 [hello@hi.events](mailto:hello@hi.events) ·
🐛 [GitHub Issues](https://github.com/HiEventsDev/hi.events/issues)

<br>

## Változásnapló

Maradjon naprakész az új funkciókkal és fejlesztésekkel a
[kiadások oldalon](https://github.com/HiEventsDev/hi.events/releases).

<br>

## Licenc

A Hi.Events **AGPL-3.0 licenc alatt áll további feltételekkel**. Kereskedelmi licenc
elérhető. [Tudjon meg többet](https://hi.events/licensing).

<br>

<div align="center">

**[Weboldal](https://hi.events)** · **[Dokumentáció](https://hi.events/docs)** · *
*[Twitter/X](https://x.com/HiEventsTickets)**

Készült ☘️-vel Írországban

</div>
